<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Setting;

trait TraitSettingSetters
{
    use TraitSettingProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setKey(string $key)
    {
        $this -> key = $key;

        return $this;
    }

    /**
     * @return static 
     */
    public function setValue(string $value)
    {
        $this -> value = $value;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
